/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.motif;

import com.sun.java.swing.BorderFactory;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JInternalFrame;
import com.sun.java.swing.JMenuItem;
import com.sun.java.swing.JPopupMenu;
import com.sun.java.swing.JSeparator;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.event.InternalFrameEvent;
import com.sun.java.swing.plaf.motif.MotifGraphicsUtils;
import com.sun.java.swing.plaf.motif.MotifInternalFrameTitlePane;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;

class MotifInternalFrameTitlePane
extends JComponent
implements LayoutManager,
ActionListener,
PropertyChangeListener {
    SystemButton systemButton;
    MinimizeButton minimizeButton;
    MaximizeButton maximizeButton;
    JPopupMenu systemMenu;
    Title title;
    JInternalFrame iFrame;
    Color color;
    Color highlight;
    Color shadow;
    static final Font defaultTitleFont = new Font("SansSerif", 0, 12);
    public static final int BUTTON_SIZE = 19;
    final int RESTORE_MENU_ITEM = 0;
    final int MOVE_MENU_ITEM = 1;
    final int SIZE_MENU_ITEM = 2;
    final int MINIMIZE_MENU_ITEM = 3;
    final int MAXIMIZE_MENU_ITEM = 4;
    final int SEPARATOR_MENU_ITEM = 5;
    final int CLOSE_MENU_ITEM = 6;
    static Dimension buttonDimension = new Dimension(19, 19);
    static /* synthetic */ Class class$com$sun$java$swing$JInternalFrame;

    public MotifInternalFrameTitlePane(JInternalFrame jInternalFrame) {
        this.iFrame = jInternalFrame;
        this.setPreferredSize(new Dimension(100, 19));
        this.systemMenu = new 1();
        JMenuItem jMenuItem = this.systemMenu.add(new JMenuItem("Restore"));
        jMenuItem.setEnabled(false);
        jMenuItem.addActionListener((ActionListener)this);
        jMenuItem = this.systemMenu.add(new JMenuItem("Move"));
        jMenuItem.setEnabled(false);
        jMenuItem.addActionListener((ActionListener)this);
        jMenuItem = this.systemMenu.add(new JMenuItem("Size"));
        jMenuItem.setEnabled(false);
        jMenuItem.addActionListener((ActionListener)this);
        jMenuItem = this.systemMenu.add(new JMenuItem("Minimize"));
        jMenuItem.addActionListener((ActionListener)this);
        jMenuItem = this.systemMenu.add(new JMenuItem("Maximize"));
        jMenuItem.addActionListener((ActionListener)this);
        this.systemMenu.add((Component)new JSeparator());
        jMenuItem = this.systemMenu.add(new JMenuItem("Close"));
        jMenuItem.addActionListener((ActionListener)this);
        this.systemButton = new SystemButton();
        this.systemButton.addActionListener(new 2());
        ((Component)((Object)this.systemButton)).addMouseListener(new 3());
        this.minimizeButton = new MinimizeButton();
        this.minimizeButton.addActionListener(this);
        this.minimizeButton.setActionCommand("Iconify");
        this.maximizeButton = new MaximizeButton();
        this.maximizeButton.addActionListener(this);
        this.maximizeButton.setActionCommand("Maximize");
        this.title = new Title(this.iFrame.getTitle());
        ((Component)((Object)this.title)).setFont(defaultTitleFont);
        ((Container)((Object)this)).setLayout(this);
        ((Container)((Object)this)).add((Component)((Object)this.systemButton));
        ((Container)((Object)this)).add((Component)((Object)this.title));
        ((Container)((Object)this)).add((Component)((Object)this.minimizeButton));
        ((Container)((Object)this)).add((Component)((Object)this.maximizeButton));
        this.iFrame.addPropertyChangeListener((PropertyChangeListener)this);
    }

    void postClosingEvent(JInternalFrame jInternalFrame) {
        InternalFrameEvent internalFrameEvent = new InternalFrameEvent(jInternalFrame, 25550);
        if ((class$com$sun$java$swing$JInternalFrame != null ? class$com$sun$java$swing$JInternalFrame : (class$com$sun$java$swing$JInternalFrame = MotifInternalFrameTitlePane.class$("com.sun.java.swing.JInternalFrame"))).getClassLoader() == null) {
            try {
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent((AWTEvent)internalFrameEvent);
                return;
            }
            catch (SecurityException securityException) {}
        }
        ((Component)((Object)this)).dispatchEvent((AWTEvent)internalFrameEvent);
    }

    void setColors(Color color, Color color2, Color color3) {
        this.color = color;
        this.highlight = color2;
        this.shadow = color3;
    }

    JPopupMenu getSystemMenu() {
        return this.systemMenu;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            if ("Close".equals(actionEvent.getActionCommand()) && this.iFrame.isClosable()) {
                this.postClosingEvent(this.iFrame);
            } else if ("Iconify".equals(actionEvent.getActionCommand()) && this.iFrame.isIconifiable()) {
                if (!this.iFrame.isIcon()) {
                    this.iFrame.setIcon(true);
                } else {
                    this.iFrame.setIcon(false);
                }
            } else if ("Minimize".equals(actionEvent.getActionCommand()) && this.iFrame.isMaximizable()) {
                this.iFrame.setIcon(true);
            } else if ("Maximize".equals(actionEvent.getActionCommand()) && this.iFrame.isMaximizable()) {
                if (!this.iFrame.isMaximum()) {
                    this.iFrame.setMaximum(true);
                } else {
                    this.iFrame.setMaximum(false);
                }
            } else if ("Restore".equals(actionEvent.getActionCommand()) && this.iFrame.isMaximizable() && this.iFrame.isMaximum()) {
                this.iFrame.setMaximum(false);
            } else if ("Restore".equals(actionEvent.getActionCommand()) && this.iFrame.isIconifiable() && this.iFrame.isIcon()) {
                this.iFrame.setIcon(false);
            }
        }
        catch (PropertyVetoException propertyVetoException) {}
        if (this.systemMenu.isVisible()) {
            this.systemMenu.setVisible(false);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        JInternalFrame cfr_ignored_0 = (JInternalFrame)propertyChangeEvent.getSource();
        boolean bl = false;
        if ("isSelected".equals(string)) {
            ((Component)((Object)this)).repaint();
            return;
        }
        if ("isMaximum".equals(string)) {
            bl = (Boolean)propertyChangeEvent.getNewValue();
            this.systemMenu.getComponentAtIndex(0).setEnabled(bl);
            this.systemMenu.getComponentAtIndex(4).setEnabled(!bl);
            return;
        }
        if ("isIcon".equals(string)) {
            bl = (Boolean)propertyChangeEvent.getNewValue();
            this.systemMenu.getComponentAtIndex(0).setEnabled(bl);
            this.systemMenu.getComponentAtIndex(4).setEnabled(!bl);
            this.systemMenu.getComponentAtIndex(3).setEnabled(!bl);
        }
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        return new Dimension(container.getSize().width, 19);
    }

    public Dimension minimumLayoutSize(Container container) {
        return new Dimension(container.getSize().width, 19);
    }

    public void layoutContainer(Container container) {
        int n = this.getWidth();
        ((Component)((Object)this.systemButton)).setBounds(0, 0, 19, 19);
        int n2 = n - 19;
        if (this.iFrame.isMaximizable()) {
            ((Component)((Object)this.maximizeButton)).setBounds(n2, 0, 19, 19);
            n2 -= 19;
        } else if (((Component)((Object)this.maximizeButton)).getParent() != null) {
            ((Component)((Object)this.maximizeButton)).getParent().remove((Component)((Object)this.maximizeButton));
        }
        if (this.iFrame.isIconifiable()) {
            ((Component)((Object)this.minimizeButton)).setBounds(n2, 0, 19, 19);
            n2 -= 19;
        } else if (((Component)((Object)this.minimizeButton)).getParent() != null) {
            ((Component)((Object)this.minimizeButton)).getParent().remove((Component)((Object)this.minimizeButton));
        }
        ((Component)((Object)this.title)).setBounds(19, 0, n2, 19);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final class 1
    extends JPopupMenu {
        public void show(Component component, int n, int n2) {
            if (!MotifInternalFrameTitlePane.this.iFrame.isIconifiable()) {
                MotifInternalFrameTitlePane.this.systemMenu.getComponentAtIndex(3).setEnabled(false);
            }
            if (!MotifInternalFrameTitlePane.this.iFrame.isMaximizable()) {
                MotifInternalFrameTitlePane.this.systemMenu.getComponentAtIndex(4).setEnabled(false);
            }
            if (!MotifInternalFrameTitlePane.this.iFrame.isMaximizable() && !MotifInternalFrameTitlePane.this.iFrame.isIconifiable()) {
                MotifInternalFrameTitlePane.this.systemMenu.getComponentAtIndex(0).setEnabled(false);
            }
            if (!MotifInternalFrameTitlePane.this.iFrame.isClosable()) {
                MotifInternalFrameTitlePane.this.systemMenu.getComponentAtIndex(6).setEnabled(false);
            }
            super.show(component, n, n2);
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            MotifInternalFrameTitlePane.this.systemMenu.show((Component)((Object)MotifInternalFrameTitlePane.this.systemButton), 0, 19);
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                MotifInternalFrameTitlePane.this.postClosingEvent(MotifInternalFrameTitlePane.this.iFrame);
                MotifInternalFrameTitlePane.this.systemMenu.setVisible(false);
            }
        }

        /* synthetic */ 3() {
        }
    }

    private abstract class FrameButton
    extends JButton {
        FrameButton() {
            MotifInternalFrameTitlePane.this = MotifInternalFrameTitlePane.this;
            this.setFocusPainted(false);
            this.setBorderPainted(false);
        }

        public boolean isFocusTraversable() {
            return false;
        }

        public void requestFocus() {
        }

        public Dimension getMinimumSize() {
            return buttonDimension;
        }

        public Dimension getPreferredSize() {
            return buttonDimension;
        }

        public void paint(Graphics graphics) {
            Dimension dimension = ((Component)((Object)this)).getSize();
            int n = dimension.width - 1;
            int n2 = dimension.height - 1;
            graphics.setColor(MotifInternalFrameTitlePane.this.color);
            graphics.fillRect(1, 1, dimension.width, dimension.height);
            boolean bl = this.getModel().isPressed();
            graphics.setColor(bl ? MotifInternalFrameTitlePane.this.shadow : MotifInternalFrameTitlePane.this.highlight);
            graphics.drawLine(0, 0, n, 0);
            graphics.drawLine(0, 0, 0, n2);
            graphics.setColor(bl ? MotifInternalFrameTitlePane.this.highlight : MotifInternalFrameTitlePane.this.shadow);
            graphics.drawLine(1, n2, n, n2);
            graphics.drawLine(n, 1, n, n2);
        }
    }

    private class MinimizeButton
    extends FrameButton {
        public void paint(Graphics graphics) {
            super.paint(graphics);
            graphics.setColor(MotifInternalFrameTitlePane.this.highlight);
            graphics.drawLine(7, 8, 7, 11);
            graphics.drawLine(7, 8, 10, 8);
            graphics.setColor(MotifInternalFrameTitlePane.this.shadow);
            graphics.drawLine(8, 11, 10, 11);
            graphics.drawLine(11, 9, 11, 11);
        }

        MinimizeButton() {
            MotifInternalFrameTitlePane.this = MotifInternalFrameTitlePane.this;
        }
    }

    private class MaximizeButton
    extends FrameButton {
        public void paint(Graphics graphics) {
            super.paint(graphics);
            int n = 14;
            boolean bl = MotifInternalFrameTitlePane.this.iFrame.isMaximum();
            graphics.setColor(bl ? MotifInternalFrameTitlePane.this.shadow : MotifInternalFrameTitlePane.this.highlight);
            graphics.drawLine(4, 4, 4, n);
            graphics.drawLine(4, 4, n, 4);
            graphics.setColor(bl ? MotifInternalFrameTitlePane.this.highlight : MotifInternalFrameTitlePane.this.shadow);
            graphics.drawLine(5, n, n, n);
            graphics.drawLine(n, 5, n, n);
        }

        MaximizeButton() {
            MotifInternalFrameTitlePane.this = MotifInternalFrameTitlePane.this;
        }
    }

    private class SystemButton
    extends FrameButton {
        public boolean isFocusTraversable() {
            return false;
        }

        public void requestFocus() {
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            graphics.setColor(MotifInternalFrameTitlePane.this.highlight);
            graphics.drawLine(4, 8, 4, 11);
            graphics.drawLine(4, 8, 14, 8);
            graphics.setColor(MotifInternalFrameTitlePane.this.shadow);
            graphics.drawLine(5, 11, 14, 11);
            graphics.drawLine(14, 9, 14, 11);
        }

        SystemButton() {
            MotifInternalFrameTitlePane.this = MotifInternalFrameTitlePane.this;
        }
    }

    private class Title
    extends FrameButton {
        Title(String string) {
            MotifInternalFrameTitlePane.this = MotifInternalFrameTitlePane.this;
            this.setText(string);
            this.setHorizontalAlignment(0);
            this.setBorder(BorderFactory.createBevelBorder((int)0, (Color)UIManager.getColor((Object)"activeCaptionBorder"), (Color)UIManager.getColor((Object)"inactiveCaptionBorder")));
            ((Component)((Object)this)).addMouseMotionListener(new 4(this));
            ((Component)((Object)this)).addMouseListener(new 5(this));
        }

        void forwardEventToParent(MouseEvent mouseEvent) {
            ((Component)((Object)this)).getParent().dispatchEvent(new MouseEvent(((Component)((Object)this)).getParent(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()));
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (MotifInternalFrameTitlePane.this.iFrame.isSelected()) {
                graphics.setColor(UIManager.getColor((Object)"activeCaptionText"));
            } else {
                graphics.setColor(UIManager.getColor((Object)"inactiveCaptionText"));
            }
            Dimension dimension = ((Component)((Object)this)).getSize();
            MotifGraphicsUtils.drawStringInRect(graphics, MotifInternalFrameTitlePane.this.iFrame.getTitle(), 0, 0, dimension.width, dimension.height, 0);
        }
    }
}

